%-------------------------------------------------------------------------%
% Filename: figs_App_D_run.m  
% Part of the paper "CS4ML: A general framework for active learning with
% arbitrary data based on Christoffel functions".
% 
% Description: generates the data for Figures 9, 10, and 11 in Appendix D.
% It computes the geometric testing error vs the number of samples, and the
% density of the points produced by the DNNs. 
%-------------------------------------------------------------------------%

clear all; close all; clc;
addpath(genpath('../utils'));

for fig_num = 1:3
    
    if fig_num == 1
        row_init = 1; row_end = 1;
    else
        row_init = 1; row_end = 2;
    end

    for row_num = row_init:row_end
        for col_num = 1:3
             
            disp(' ');
            disp(['------------------------------------------------------------------------']);
            disp(['Running Figure App D',num2str(fig_num),'_',num2str(row_num),'_',num2str(col_num)]);
            disp(['------------------------------------------------------------------------']);
            disp(' ');
            fig_App_D_data(fig_num,row_num,col_num); 
    
        end
    end
end